package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateSmsChannelRequest(
    applicationId: __string,
    smsChannelRequest: zio.aws.pinpoint.model.SMSChannelRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest = {
    import UpdateSmsChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .smsChannelRequest(smsChannelRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateSmsChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateSmsChannelRequest.wrap(buildAwsValue())
}
object UpdateSmsChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateSmsChannelRequest =
      zio.aws.pinpoint.model
        .UpdateSmsChannelRequest(applicationId, smsChannelRequest.asEditable)
    def applicationId: __string
    def smsChannelRequest: zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSmsChannelRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly] =
      ZIO.succeed(smsChannelRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateSmsChannelRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val smsChannelRequest
        : zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.SMSChannelRequest.wrap(impl.smsChannelRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest
  ): zio.aws.pinpoint.model.UpdateSmsChannelRequest.ReadOnly = new Wrapper(impl)
}
