package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class UpdateSmsTemplateRequest(
    createNewVersion: Option[__boolean] = None,
    smsTemplateRequest: zio.aws.pinpoint.model.SMSTemplateRequest,
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest = {
    import UpdateSmsTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
      .builder()
      .optionallyWith(
        createNewVersion.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.createNewVersion)
      .smsTemplateRequest(smsTemplateRequest.buildAwsValue())
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateSmsTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateSmsTemplateRequest.wrap(buildAwsValue())
}
object UpdateSmsTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateSmsTemplateRequest =
      zio.aws.pinpoint.model.UpdateSmsTemplateRequest(
        createNewVersion.map(value => value),
        smsTemplateRequest.asEditable,
        templateName,
        version.map(value => value)
      )
    def createNewVersion: Option[__boolean]
    def smsTemplateRequest: zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly
    def templateName: __string
    def version: Option[__string]
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getSmsTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly
    ] = ZIO.succeed(smsTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdateSmsTemplateRequest.ReadOnly {
    override val createNewVersion: Option[__boolean] = scala
      .Option(impl.createNewVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val smsTemplateRequest
        : zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.SMSTemplateRequest.wrap(impl.smsTemplateRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest
  ): zio.aws.pinpoint.model.UpdateSmsTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
