package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateTemplateActiveVersionRequest(
    templateActiveVersionRequest: zio.aws.pinpoint.model.TemplateActiveVersionRequest,
    templateName: __string,
    templateType: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest = {
    import UpdateTemplateActiveVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest
      .builder()
      .templateActiveVersionRequest(
        templateActiveVersionRequest.buildAwsValue()
      )
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(__string.unwrap(templateType): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest
      .wrap(buildAwsValue())
}
object UpdateTemplateActiveVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest =
      zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest(
        templateActiveVersionRequest.asEditable,
        templateName,
        templateType
      )
    def templateActiveVersionRequest
        : zio.aws.pinpoint.model.TemplateActiveVersionRequest.ReadOnly
    def templateName: __string
    def templateType: __string
    def getTemplateActiveVersionRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.TemplateActiveVersionRequest.ReadOnly
    ] = ZIO.succeed(templateActiveVersionRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType: ZIO[Any, Nothing, __string] = ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest
  ) extends zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest.ReadOnly {
    override val templateActiveVersionRequest
        : zio.aws.pinpoint.model.TemplateActiveVersionRequest.ReadOnly =
      zio.aws.pinpoint.model.TemplateActiveVersionRequest
        .wrap(impl.templateActiveVersionRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest
  ): zio.aws.pinpoint.model.UpdateTemplateActiveVersionRequest.ReadOnly =
    new Wrapper(impl)
}
