package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateTemplateActiveVersionResponse(
    messageBody: zio.aws.pinpoint.model.MessageBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse = {
    import UpdateTemplateActiveVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse
      .builder()
      .messageBody(messageBody.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse
      .wrap(buildAwsValue())
}
object UpdateTemplateActiveVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse =
      zio.aws.pinpoint.model
        .UpdateTemplateActiveVersionResponse(messageBody.asEditable)
    def messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly
    def getMessageBody
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageBody.ReadOnly] =
      ZIO.succeed(messageBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse
  ) extends zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly {
    override val messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly =
      zio.aws.pinpoint.model.MessageBody.wrap(impl.messageBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse
  ): zio.aws.pinpoint.model.UpdateTemplateActiveVersionResponse.ReadOnly =
    new Wrapper(impl)
}
