package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateVoiceChannelRequest(
    applicationId: __string,
    voiceChannelRequest: zio.aws.pinpoint.model.VoiceChannelRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest = {
    import UpdateVoiceChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .voiceChannelRequest(voiceChannelRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateVoiceChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateVoiceChannelRequest.wrap(buildAwsValue())
}
object UpdateVoiceChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateVoiceChannelRequest =
      zio.aws.pinpoint.model.UpdateVoiceChannelRequest(
        applicationId,
        voiceChannelRequest.asEditable
      )
    def applicationId: __string
    def voiceChannelRequest: zio.aws.pinpoint.model.VoiceChannelRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getVoiceChannelRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.VoiceChannelRequest.ReadOnly
    ] = ZIO.succeed(voiceChannelRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateVoiceChannelRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val voiceChannelRequest
        : zio.aws.pinpoint.model.VoiceChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.VoiceChannelRequest
        .wrap(impl.voiceChannelRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest
  ): zio.aws.pinpoint.model.UpdateVoiceChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
