package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class UpdateVoiceTemplateRequest(
    createNewVersion: Option[__boolean] = None,
    templateName: __string,
    version: Option[__string] = None,
    voiceTemplateRequest: zio.aws.pinpoint.model.VoiceTemplateRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest = {
    import UpdateVoiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
      .builder()
      .optionallyWith(
        createNewVersion.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.createNewVersion)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .voiceTemplateRequest(voiceTemplateRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.wrap(buildAwsValue())
}
object UpdateVoiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateVoiceTemplateRequest =
      zio.aws.pinpoint.model.UpdateVoiceTemplateRequest(
        createNewVersion.map(value => value),
        templateName,
        version.map(value => value),
        voiceTemplateRequest.asEditable
      )
    def createNewVersion: Option[__boolean]
    def templateName: __string
    def version: Option[__string]
    def voiceTemplateRequest
        : zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
    def getVoiceTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly
    ] = ZIO.succeed(voiceTemplateRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.ReadOnly {
    override val createNewVersion: Option[__boolean] = scala
      .Option(impl.createNewVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val voiceTemplateRequest
        : zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.VoiceTemplateRequest
        .wrap(impl.voiceTemplateRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest
  ): zio.aws.pinpoint.model.UpdateVoiceTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
