package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__boolean
import scala.jdk.CollectionConverters.*
final case class VerificationResponse(valid: Option[__boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VerificationResponse = {
    import VerificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VerificationResponse
      .builder()
      .optionallyWith(
        valid.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.valid)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VerificationResponse.ReadOnly =
    zio.aws.pinpoint.model.VerificationResponse.wrap(buildAwsValue())
}
object VerificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VerificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VerificationResponse =
      zio.aws.pinpoint.model.VerificationResponse(valid.map(value => value))
    def valid: Option[__boolean]
    def getValid: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("valid", valid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VerificationResponse
  ) extends zio.aws.pinpoint.model.VerificationResponse.ReadOnly {
    override val valid: Option[__boolean] = scala
      .Option(impl.valid())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VerificationResponse
  ): zio.aws.pinpoint.model.VerificationResponse.ReadOnly = new Wrapper(impl)
}
