package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VerifyOtpMessageResponse(
    verificationResponse: zio.aws.pinpoint.model.VerificationResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse = {
    import VerifyOtpMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse
      .builder()
      .verificationResponse(verificationResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly =
    zio.aws.pinpoint.model.VerifyOtpMessageResponse.wrap(buildAwsValue())
}
object VerifyOtpMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VerifyOtpMessageResponse =
      zio.aws.pinpoint.model
        .VerifyOtpMessageResponse(verificationResponse.asEditable)
    def verificationResponse
        : zio.aws.pinpoint.model.VerificationResponse.ReadOnly
    def getVerificationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.VerificationResponse.ReadOnly
    ] = ZIO.succeed(verificationResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse
  ) extends zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly {
    override val verificationResponse
        : zio.aws.pinpoint.model.VerificationResponse.ReadOnly =
      zio.aws.pinpoint.model.VerificationResponse
        .wrap(impl.verificationResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VerifyOtpMessageResponse
  ): zio.aws.pinpoint.model.VerifyOtpMessageResponse.ReadOnly = new Wrapper(
    impl
  )
}
