package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__boolean
import scala.jdk.CollectionConverters.*
final case class VoiceChannelRequest(enabled: Option[__boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VoiceChannelRequest = {
    import VoiceChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VoiceChannelRequest
      .builder()
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VoiceChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.VoiceChannelRequest.wrap(buildAwsValue())
}
object VoiceChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VoiceChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VoiceChannelRequest =
      zio.aws.pinpoint.model.VoiceChannelRequest(enabled.map(value => value))
    def enabled: Option[__boolean]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceChannelRequest
  ) extends zio.aws.pinpoint.model.VoiceChannelRequest.ReadOnly {
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceChannelRequest
  ): zio.aws.pinpoint.model.VoiceChannelRequest.ReadOnly = new Wrapper(impl)
}
