package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class VoiceMessage(
    body: Option[__string] = None,
    languageCode: Option[__string] = None,
    originationNumber: Option[__string] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    voiceId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VoiceMessage = {
    import VoiceMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VoiceMessage
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        languageCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        originationNumber.map(value => __string.unwrap(value): java.lang.String)
      )(_.originationNumber)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        voiceId.map(value => __string.unwrap(value): java.lang.String)
      )(_.voiceId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VoiceMessage.ReadOnly =
    zio.aws.pinpoint.model.VoiceMessage.wrap(buildAwsValue())
}
object VoiceMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VoiceMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VoiceMessage =
      zio.aws.pinpoint.model.VoiceMessage(
        body.map(value => value),
        languageCode.map(value => value),
        originationNumber.map(value => value),
        substitutions.map(value => value),
        voiceId.map(value => value)
      )
    def body: Option[__string]
    def languageCode: Option[__string]
    def originationNumber: Option[__string]
    def substitutions: Option[Map[__string, List[__string]]]
    def voiceId: Option[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getOriginationNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originationNumber", originationNumber)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getVoiceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("voiceId", voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceMessage
  ) extends zio.aws.pinpoint.model.VoiceMessage.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val languageCode: Option[__string] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val originationNumber: Option[__string] = scala
      .Option(impl.originationNumber())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val voiceId: Option[__string] = scala
      .Option(impl.voiceId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceMessage
  ): zio.aws.pinpoint.model.VoiceMessage.ReadOnly = new Wrapper(impl)
}
