package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class VoiceTemplateRequest(
    body: Option[__string] = None,
    defaultSubstitutions: Option[__string] = None,
    languageCode: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    voiceId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest = {
    import VoiceTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(
        languageCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .optionallyWith(
        voiceId.map(value => __string.unwrap(value): java.lang.String)
      )(_.voiceId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.VoiceTemplateRequest.wrap(buildAwsValue())
}
object VoiceTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VoiceTemplateRequest =
      zio.aws.pinpoint.model.VoiceTemplateRequest(
        body.map(value => value),
        defaultSubstitutions.map(value => value),
        languageCode.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        voiceId.map(value => value)
      )
    def body: Option[__string]
    def defaultSubstitutions: Option[__string]
    def languageCode: Option[__string]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def voiceId: Option[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getVoiceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("voiceId", voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
  ) extends zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val languageCode: Option[__string] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val voiceId: Option[__string] = scala
      .Option(impl.voiceId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceTemplateRequest
  ): zio.aws.pinpoint.model.VoiceTemplateRequest.ReadOnly = new Wrapper(impl)
}
