package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class VoiceTemplateResponse(
    arn: Option[__string] = None,
    body: Option[__string] = None,
    creationDate: __string,
    defaultSubstitutions: Option[__string] = None,
    languageCode: Option[__string] = None,
    lastModifiedDate: __string,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Option[__string] = None,
    voiceId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.VoiceTemplateResponse = {
    import VoiceTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.VoiceTemplateResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(
        languageCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.languageCode)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        voiceId.map(value => __string.unwrap(value): java.lang.String)
      )(_.voiceId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.VoiceTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.VoiceTemplateResponse.wrap(buildAwsValue())
}
object VoiceTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.VoiceTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.VoiceTemplateResponse =
      zio.aws.pinpoint.model.VoiceTemplateResponse(
        arn.map(value => value),
        body.map(value => value),
        creationDate,
        defaultSubstitutions.map(value => value),
        languageCode.map(value => value),
        lastModifiedDate,
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value),
        voiceId.map(value => value)
      )
    def arn: Option[__string]
    def body: Option[__string]
    def creationDate: __string
    def defaultSubstitutions: Option[__string]
    def languageCode: Option[__string]
    def lastModifiedDate: __string
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Option[__string]
    def voiceId: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getLanguageCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
    def getVoiceId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("voiceId", voiceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceTemplateResponse
  ) extends zio.aws.pinpoint.model.VoiceTemplateResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val languageCode: Option[__string] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val voiceId: Option[__string] = scala
      .Option(impl.voiceId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.VoiceTemplateResponse
  ): zio.aws.pinpoint.model.VoiceTemplateResponse.ReadOnly = new Wrapper(impl)
}
