package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class WaitActivity(
    nextActivity: Option[__string] = None,
    waitTime: Option[zio.aws.pinpoint.model.WaitTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WaitActivity = {
    import WaitActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WaitActivity
      .builder()
      .optionallyWith(
        nextActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextActivity)
      .optionallyWith(waitTime.map(value => value.buildAwsValue()))(_.waitTime)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WaitActivity.ReadOnly =
    zio.aws.pinpoint.model.WaitActivity.wrap(buildAwsValue())
}
object WaitActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WaitActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WaitActivity =
      zio.aws.pinpoint.model.WaitActivity(
        nextActivity.map(value => value),
        waitTime.map(value => value.asEditable)
      )
    def nextActivity: Option[__string]
    def waitTime: Option[zio.aws.pinpoint.model.WaitTime.ReadOnly]
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getWaitTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.WaitTime.ReadOnly] =
      AwsError.unwrapOptionField("waitTime", waitTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WaitActivity
  ) extends zio.aws.pinpoint.model.WaitActivity.ReadOnly {
    override val nextActivity: Option[__string] = scala
      .Option(impl.nextActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val waitTime: Option[zio.aws.pinpoint.model.WaitTime.ReadOnly] =
      scala
        .Option(impl.waitTime())
        .map(value => zio.aws.pinpoint.model.WaitTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WaitActivity
  ): zio.aws.pinpoint.model.WaitActivity.ReadOnly = new Wrapper(impl)
}
