package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class WaitTime(
    waitFor: Option[__string] = None,
    waitUntil: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WaitTime = {
    import WaitTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WaitTime
      .builder()
      .optionallyWith(
        waitFor.map(value => __string.unwrap(value): java.lang.String)
      )(_.waitFor)
      .optionallyWith(
        waitUntil.map(value => __string.unwrap(value): java.lang.String)
      )(_.waitUntil)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WaitTime.ReadOnly =
    zio.aws.pinpoint.model.WaitTime.wrap(buildAwsValue())
}
object WaitTime {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.WaitTime] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WaitTime = zio.aws.pinpoint.model
      .WaitTime(waitFor.map(value => value), waitUntil.map(value => value))
    def waitFor: Option[__string]
    def waitUntil: Option[__string]
    def getWaitFor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("waitFor", waitFor)
    def getWaitUntil: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("waitUntil", waitUntil)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WaitTime
  ) extends zio.aws.pinpoint.model.WaitTime.ReadOnly {
    override val waitFor: Option[__string] = scala
      .Option(impl.waitFor())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val waitUntil: Option[__string] = scala
      .Option(impl.waitUntil())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WaitTime
  ): zio.aws.pinpoint.model.WaitTime.ReadOnly = new Wrapper(impl)
}
