package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__boolean
import scala.jdk.CollectionConverters.*
final case class WriteApplicationSettingsRequest(
    campaignHook: Option[zio.aws.pinpoint.model.CampaignHook] = None,
    cloudWatchMetricsEnabled: Option[__boolean] = None,
    eventTaggingEnabled: Option[__boolean] = None,
    limits: Option[zio.aws.pinpoint.model.CampaignLimits] = None,
    quietTime: Option[zio.aws.pinpoint.model.QuietTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest = {
    import WriteApplicationSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
      .builder()
      .optionallyWith(campaignHook.map(value => value.buildAwsValue()))(
        _.campaignHook
      )
      .optionallyWith(
        cloudWatchMetricsEnabled.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.cloudWatchMetricsEnabled)
      .optionallyWith(
        eventTaggingEnabled.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.eventTaggingEnabled)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteApplicationSettingsRequest.wrap(buildAwsValue())
}
object WriteApplicationSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteApplicationSettingsRequest =
      zio.aws.pinpoint.model.WriteApplicationSettingsRequest(
        campaignHook.map(value => value.asEditable),
        cloudWatchMetricsEnabled.map(value => value),
        eventTaggingEnabled.map(value => value),
        limits.map(value => value.asEditable),
        quietTime.map(value => value.asEditable)
      )
    def campaignHook: Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def cloudWatchMetricsEnabled: Option[__boolean]
    def eventTaggingEnabled: Option[__boolean]
    def limits: Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def getCampaignHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("campaignHook", campaignHook)
    def getCloudWatchMetricsEnabled: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("cloudWatchMetricsEnabled", cloudWatchMetricsEnabled)
    def getEventTaggingEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("eventTaggingEnabled", eventTaggingEnabled)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
  ) extends zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly {
    override val campaignHook
        : Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly] = scala
      .Option(impl.campaignHook())
      .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val cloudWatchMetricsEnabled: Option[__boolean] = scala
      .Option(impl.cloudWatchMetricsEnabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val eventTaggingEnabled: Option[__boolean] = scala
      .Option(impl.eventTaggingEnabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val limits
        : Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] = scala
      .Option(impl.limits())
      .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      scala
        .Option(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest
  ): zio.aws.pinpoint.model.WriteApplicationSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
