package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __integer, __string}
import scala.jdk.CollectionConverters.*
final case class WriteCampaignRequest(
    additionalTreatments: Option[
      Iterable[zio.aws.pinpoint.model.WriteTreatmentResource]
    ] = None,
    customDeliveryConfiguration: Option[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration
    ] = None,
    description: Option[__string] = None,
    holdoutPercent: Option[__integer] = None,
    hook: Option[zio.aws.pinpoint.model.CampaignHook] = None,
    isPaused: Option[__boolean] = None,
    limits: Option[zio.aws.pinpoint.model.CampaignLimits] = None,
    messageConfiguration: Option[zio.aws.pinpoint.model.MessageConfiguration] =
      None,
    name: Option[__string] = None,
    schedule: Option[zio.aws.pinpoint.model.Schedule] = None,
    segmentId: Option[__string] = None,
    segmentVersion: Option[__integer] = None,
    tags: Option[Map[__string, __string]] = None,
    templateConfiguration: Option[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = None,
    treatmentDescription: Option[__string] = None,
    treatmentName: Option[__string] = None,
    priority: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest = {
    import WriteCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
      .builder()
      .optionallyWith(
        additionalTreatments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalTreatments)
      .optionallyWith(
        customDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.customDeliveryConfiguration)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        holdoutPercent.map(value => __integer.unwrap(value): Integer)
      )(_.holdoutPercent)
      .optionallyWith(hook.map(value => value.buildAwsValue()))(_.hook)
      .optionallyWith(
        isPaused.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.isPaused)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(messageConfiguration.map(value => value.buildAwsValue()))(
        _.messageConfiguration
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        segmentId.map(value => __string.unwrap(value): java.lang.String)
      )(_.segmentId)
      .optionallyWith(
        segmentVersion.map(value => __integer.unwrap(value): Integer)
      )(_.segmentVersion)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(
        treatmentDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.treatmentDescription)
      .optionallyWith(
        treatmentName.map(value => __string.unwrap(value): java.lang.String)
      )(_.treatmentName)
      .optionallyWith(priority.map(value => __integer.unwrap(value): Integer))(
        _.priority
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteCampaignRequest.wrap(buildAwsValue())
}
object WriteCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteCampaignRequest =
      zio.aws.pinpoint.model.WriteCampaignRequest(
        additionalTreatments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customDeliveryConfiguration.map(value => value.asEditable),
        description.map(value => value),
        holdoutPercent.map(value => value),
        hook.map(value => value.asEditable),
        isPaused.map(value => value),
        limits.map(value => value.asEditable),
        messageConfiguration.map(value => value.asEditable),
        name.map(value => value),
        schedule.map(value => value.asEditable),
        segmentId.map(value => value),
        segmentVersion.map(value => value),
        tags.map(value => value),
        templateConfiguration.map(value => value.asEditable),
        treatmentDescription.map(value => value),
        treatmentName.map(value => value),
        priority.map(value => value)
      )
    def additionalTreatments
        : Option[List[zio.aws.pinpoint.model.WriteTreatmentResource.ReadOnly]]
    def customDeliveryConfiguration
        : Option[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly]
    def description: Option[__string]
    def holdoutPercent: Option[__integer]
    def hook: Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def isPaused: Option[__boolean]
    def limits: Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def messageConfiguration
        : Option[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly]
    def name: Option[__string]
    def schedule: Option[zio.aws.pinpoint.model.Schedule.ReadOnly]
    def segmentId: Option[__string]
    def segmentVersion: Option[__integer]
    def tags: Option[Map[__string, __string]]
    def templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def treatmentDescription: Option[__string]
    def treatmentName: Option[__string]
    def priority: Option[__integer]
    def getAdditionalTreatments: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.WriteTreatmentResource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("additionalTreatments", additionalTreatments)
    def getCustomDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDeliveryConfiguration",
      customDeliveryConfiguration
    )
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getHoldoutPercent: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("holdoutPercent", holdoutPercent)
    def getHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("hook", hook)
    def getIsPaused: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isPaused", isPaused)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getMessageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MessageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfiguration", messageConfiguration)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
    def getSegmentVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("segmentVersion", segmentVersion)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTreatmentDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentDescription", treatmentDescription)
    def getTreatmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
    def getPriority: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
  ) extends zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly {
    override val additionalTreatments
        : Option[List[zio.aws.pinpoint.model.WriteTreatmentResource.ReadOnly]] =
      scala
        .Option(impl.additionalTreatments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.WriteTreatmentResource.wrap(item)
          }.toList
        )
    override val customDeliveryConfiguration
        : Option[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly] =
      scala
        .Option(impl.customDeliveryConfiguration())
        .map(value =>
          zio.aws.pinpoint.model.CustomDeliveryConfiguration.wrap(value)
        )
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val holdoutPercent: Option[__integer] = scala
      .Option(impl.holdoutPercent())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val hook: Option[zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      scala
        .Option(impl.hook())
        .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val isPaused: Option[__boolean] = scala
      .Option(impl.isPaused())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val limits
        : Option[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] = scala
      .Option(impl.limits())
      .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val messageConfiguration
        : Option[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly] = scala
      .Option(impl.messageConfiguration())
      .map(value => zio.aws.pinpoint.model.MessageConfiguration.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val schedule: Option[zio.aws.pinpoint.model.Schedule.ReadOnly] =
      scala
        .Option(impl.schedule())
        .map(value => zio.aws.pinpoint.model.Schedule.wrap(value))
    override val segmentId: Option[__string] = scala
      .Option(impl.segmentId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val segmentVersion: Option[__integer] = scala
      .Option(impl.segmentVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] = scala
      .Option(impl.templateConfiguration())
      .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val treatmentDescription: Option[__string] = scala
      .Option(impl.treatmentDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val treatmentName: Option[__string] = scala
      .Option(impl.treatmentName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val priority: Option[__integer] = scala
      .Option(impl.priority())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest
  ): zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly = new Wrapper(impl)
}
