package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class WriteEventStream(
    destinationStreamArn: __string,
    roleArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteEventStream = {
    import WriteEventStream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteEventStream
      .builder()
      .destinationStreamArn(
        __string.unwrap(destinationStreamArn): java.lang.String
      )
      .roleArn(__string.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteEventStream.ReadOnly =
    zio.aws.pinpoint.model.WriteEventStream.wrap(buildAwsValue())
}
object WriteEventStream {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteEventStream
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteEventStream =
      zio.aws.pinpoint.model.WriteEventStream(destinationStreamArn, roleArn)
    def destinationStreamArn: __string
    def roleArn: __string
    def getDestinationStreamArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(destinationStreamArn)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteEventStream
  ) extends zio.aws.pinpoint.model.WriteEventStream.ReadOnly {
    override val destinationStreamArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.destinationStreamArn())
    override val roleArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteEventStream
  ): zio.aws.pinpoint.model.WriteEventStream.ReadOnly = new Wrapper(impl)
}
