package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class WriteJourneyRequest(
    activities: Option[Map[__string, zio.aws.pinpoint.model.Activity]] = None,
    creationDate: Option[__string] = None,
    lastModifiedDate: Option[__string] = None,
    limits: Option[zio.aws.pinpoint.model.JourneyLimits] = None,
    localTime: Option[__boolean] = None,
    name: __string,
    quietTime: Option[zio.aws.pinpoint.model.QuietTime] = None,
    refreshFrequency: Option[__string] = None,
    schedule: Option[zio.aws.pinpoint.model.JourneySchedule] = None,
    startActivity: Option[__string] = None,
    startCondition: Option[zio.aws.pinpoint.model.StartCondition] = None,
    state: Option[zio.aws.pinpoint.model.State] = None,
    waitForQuietTime: Option[__boolean] = None,
    refreshOnSegmentUpdate: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest = {
    import WriteJourneyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
      .builder()
      .optionallyWith(
        activities.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.activities)
      .optionallyWith(
        creationDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(
        localTime.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.localTime)
      .name(__string.unwrap(name): java.lang.String)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .optionallyWith(
        refreshFrequency.map(value => __string.unwrap(value): java.lang.String)
      )(_.refreshFrequency)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        startActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.startActivity)
      .optionallyWith(startCondition.map(value => value.buildAwsValue()))(
        _.startCondition
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        waitForQuietTime.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.waitForQuietTime)
      .optionallyWith(
        refreshOnSegmentUpdate.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.refreshOnSegmentUpdate)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteJourneyRequest.wrap(buildAwsValue())
}
object WriteJourneyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteJourneyRequest =
      zio.aws.pinpoint.model.WriteJourneyRequest(
        activities.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        limits.map(value => value.asEditable),
        localTime.map(value => value),
        name,
        quietTime.map(value => value.asEditable),
        refreshFrequency.map(value => value),
        schedule.map(value => value.asEditable),
        startActivity.map(value => value),
        startCondition.map(value => value.asEditable),
        state.map(value => value),
        waitForQuietTime.map(value => value),
        refreshOnSegmentUpdate.map(value => value)
      )
    def activities
        : Option[Map[__string, zio.aws.pinpoint.model.Activity.ReadOnly]]
    def creationDate: Option[__string]
    def lastModifiedDate: Option[__string]
    def limits: Option[zio.aws.pinpoint.model.JourneyLimits.ReadOnly]
    def localTime: Option[__boolean]
    def name: __string
    def quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def refreshFrequency: Option[__string]
    def schedule: Option[zio.aws.pinpoint.model.JourneySchedule.ReadOnly]
    def startActivity: Option[__string]
    def startCondition: Option[zio.aws.pinpoint.model.StartCondition.ReadOnly]
    def state: Option[zio.aws.pinpoint.model.State]
    def waitForQuietTime: Option[__boolean]
    def refreshOnSegmentUpdate: Option[__boolean]
    def getActivities: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.Activity.ReadOnly
    ]] = AwsError.unwrapOptionField("activities", activities)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.JourneyLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getLocalTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("localTime", localTime)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
    def getRefreshFrequency: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("refreshFrequency", refreshFrequency)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.JourneySchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getStartActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startActivity", startActivity)
    def getStartCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.StartCondition.ReadOnly] =
      AwsError.unwrapOptionField("startCondition", startCondition)
    def getState: ZIO[Any, AwsError, zio.aws.pinpoint.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getWaitForQuietTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("waitForQuietTime", waitForQuietTime)
    def getRefreshOnSegmentUpdate: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("refreshOnSegmentUpdate", refreshOnSegmentUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
  ) extends zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly {
    override val activities
        : Option[Map[__string, zio.aws.pinpoint.model.Activity.ReadOnly]] =
      scala
        .Option(impl.activities())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pinpoint.model.primitives
                .__string(key) -> zio.aws.pinpoint.model.Activity.wrap(value)
            })
            .toMap
        )
    override val creationDate: Option[__string] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val limits: Option[zio.aws.pinpoint.model.JourneyLimits.ReadOnly] =
      scala
        .Option(impl.limits())
        .map(value => zio.aws.pinpoint.model.JourneyLimits.wrap(value))
    override val localTime: Option[__boolean] = scala
      .Option(impl.localTime())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val name: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.name())
    override val quietTime: Option[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      scala
        .Option(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
    override val refreshFrequency: Option[__string] = scala
      .Option(impl.refreshFrequency())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val schedule
        : Option[zio.aws.pinpoint.model.JourneySchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.pinpoint.model.JourneySchedule.wrap(value))
    override val startActivity: Option[__string] = scala
      .Option(impl.startActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val startCondition
        : Option[zio.aws.pinpoint.model.StartCondition.ReadOnly] = scala
      .Option(impl.startCondition())
      .map(value => zio.aws.pinpoint.model.StartCondition.wrap(value))
    override val state: Option[zio.aws.pinpoint.model.State] = scala
      .Option(impl.state())
      .map(value => zio.aws.pinpoint.model.State.wrap(value))
    override val waitForQuietTime: Option[__boolean] = scala
      .Option(impl.waitForQuietTime())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val refreshOnSegmentUpdate: Option[__boolean] = scala
      .Option(impl.refreshOnSegmentUpdate())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteJourneyRequest
  ): zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly = new Wrapper(impl)
}
