package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class WriteSegmentRequest(
    dimensions: Option[zio.aws.pinpoint.model.SegmentDimensions] = None,
    name: Option[__string] = None,
    segmentGroups: Option[zio.aws.pinpoint.model.SegmentGroupList] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest = {
    import WriteSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
      .builder()
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(segmentGroups.map(value => value.buildAwsValue()))(
        _.segmentGroups
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly =
    zio.aws.pinpoint.model.WriteSegmentRequest.wrap(buildAwsValue())
}
object WriteSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.WriteSegmentRequest =
      zio.aws.pinpoint.model.WriteSegmentRequest(
        dimensions.map(value => value.asEditable),
        name.map(value => value),
        segmentGroups.map(value => value.asEditable),
        tags.map(value => value)
      )
    def dimensions: Option[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]
    def name: Option[__string]
    def segmentGroups: Option[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly]
    def tags: Option[Map[__string, __string]]
    def getDimensions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSegmentGroups
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] =
      AwsError.unwrapOptionField("segmentGroups", segmentGroups)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
  ) extends zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly {
    override val dimensions
        : Option[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly] = scala
      .Option(impl.dimensions())
      .map(value => zio.aws.pinpoint.model.SegmentDimensions.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val segmentGroups
        : Option[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] = scala
      .Option(impl.segmentGroups())
      .map(value => zio.aws.pinpoint.model.SegmentGroupList.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.WriteSegmentRequest
  ): zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly = new Wrapper(impl)
}
