package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Activity(
    custom: Optional[zio.aws.pinpoint.model.CustomMessageActivity] =
      Optional.Absent,
    conditionalSplit: Optional[
      zio.aws.pinpoint.model.ConditionalSplitActivity
    ] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    email: Optional[zio.aws.pinpoint.model.EmailMessageActivity] =
      Optional.Absent,
    holdout: Optional[zio.aws.pinpoint.model.HoldoutActivity] = Optional.Absent,
    multiCondition: Optional[
      zio.aws.pinpoint.model.MultiConditionalSplitActivity
    ] = Optional.Absent,
    push: Optional[zio.aws.pinpoint.model.PushMessageActivity] =
      Optional.Absent,
    randomSplit: Optional[zio.aws.pinpoint.model.RandomSplitActivity] =
      Optional.Absent,
    sms: Optional[zio.aws.pinpoint.model.SMSMessageActivity] = Optional.Absent,
    waitValue: Optional[zio.aws.pinpoint.model.WaitActivity] = Optional.Absent,
    contactCenter: Optional[zio.aws.pinpoint.model.ContactCenterActivity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Activity = {
    import Activity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Activity
      .builder()
      .optionallyWith(custom.map(value => value.buildAwsValue()))(_.custom)
      .optionallyWith(conditionalSplit.map(value => value.buildAwsValue()))(
        _.conditionalSplit
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(email.map(value => value.buildAwsValue()))(_.email)
      .optionallyWith(holdout.map(value => value.buildAwsValue()))(_.holdout)
      .optionallyWith(multiCondition.map(value => value.buildAwsValue()))(
        _.multiCondition
      )
      .optionallyWith(push.map(value => value.buildAwsValue()))(_.push)
      .optionallyWith(randomSplit.map(value => value.buildAwsValue()))(
        _.randomSplit
      )
      .optionallyWith(sms.map(value => value.buildAwsValue()))(_.sms)
      .optionallyWith(waitValue.map(value => value.buildAwsValue()))(
        _.waitValue
      )
      .optionallyWith(contactCenter.map(value => value.buildAwsValue()))(
        _.contactCenter
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Activity.ReadOnly =
    zio.aws.pinpoint.model.Activity.wrap(buildAwsValue())
}
object Activity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Activity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Activity =
      zio.aws.pinpoint.model.Activity(
        custom.map(value => value.asEditable),
        conditionalSplit.map(value => value.asEditable),
        description.map(value => value),
        email.map(value => value.asEditable),
        holdout.map(value => value.asEditable),
        multiCondition.map(value => value.asEditable),
        push.map(value => value.asEditable),
        randomSplit.map(value => value.asEditable),
        sms.map(value => value.asEditable),
        waitValue.map(value => value.asEditable),
        contactCenter.map(value => value.asEditable)
      )
    def custom: Optional[zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly]
    def conditionalSplit
        : Optional[zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly]
    def description: Optional[__string]
    def email: Optional[zio.aws.pinpoint.model.EmailMessageActivity.ReadOnly]
    def holdout: Optional[zio.aws.pinpoint.model.HoldoutActivity.ReadOnly]
    def multiCondition: Optional[
      zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly
    ]
    def push: Optional[zio.aws.pinpoint.model.PushMessageActivity.ReadOnly]
    def randomSplit
        : Optional[zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly]
    def sms: Optional[zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly]
    def waitValue: Optional[zio.aws.pinpoint.model.WaitActivity.ReadOnly]
    def contactCenter
        : Optional[zio.aws.pinpoint.model.ContactCenterActivity.ReadOnly]
    def getCustom: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("custom", custom)
    def getConditionalSplit: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly
    ] = AwsError.unwrapOptionField("conditionalSplit", conditionalSplit)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getEmail: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EmailMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("email", email)
    def getHoldout
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.HoldoutActivity.ReadOnly] =
      AwsError.unwrapOptionField("holdout", holdout)
    def getMultiCondition: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly
    ] = AwsError.unwrapOptionField("multiCondition", multiCondition)
    def getPush: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.PushMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("push", push)
    def getRandomSplit: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly
    ] = AwsError.unwrapOptionField("randomSplit", randomSplit)
    def getSms: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly
    ] = AwsError.unwrapOptionField("sms", sms)
    def getWaitValue
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.WaitActivity.ReadOnly] =
      AwsError.unwrapOptionField("waitValue", waitValue)
    def getContactCenter: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.ContactCenterActivity.ReadOnly
    ] = AwsError.unwrapOptionField("contactCenter", contactCenter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Activity
  ) extends zio.aws.pinpoint.model.Activity.ReadOnly {
    override val custom
        : Optional[zio.aws.pinpoint.model.CustomMessageActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.custom())
        .map(value => zio.aws.pinpoint.model.CustomMessageActivity.wrap(value))
    override val conditionalSplit
        : Optional[zio.aws.pinpoint.model.ConditionalSplitActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalSplit())
        .map(value =>
          zio.aws.pinpoint.model.ConditionalSplitActivity.wrap(value)
        )
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val email
        : Optional[zio.aws.pinpoint.model.EmailMessageActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.email())
        .map(value => zio.aws.pinpoint.model.EmailMessageActivity.wrap(value))
    override val holdout
        : Optional[zio.aws.pinpoint.model.HoldoutActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.holdout())
        .map(value => zio.aws.pinpoint.model.HoldoutActivity.wrap(value))
    override val multiCondition: Optional[
      zio.aws.pinpoint.model.MultiConditionalSplitActivity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multiCondition())
      .map(value =>
        zio.aws.pinpoint.model.MultiConditionalSplitActivity.wrap(value)
      )
    override val push
        : Optional[zio.aws.pinpoint.model.PushMessageActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.push())
        .map(value => zio.aws.pinpoint.model.PushMessageActivity.wrap(value))
    override val randomSplit
        : Optional[zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.randomSplit())
        .map(value => zio.aws.pinpoint.model.RandomSplitActivity.wrap(value))
    override val sms
        : Optional[zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sms())
        .map(value => zio.aws.pinpoint.model.SMSMessageActivity.wrap(value))
    override val waitValue
        : Optional[zio.aws.pinpoint.model.WaitActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.waitValue())
        .map(value => zio.aws.pinpoint.model.WaitActivity.wrap(value))
    override val contactCenter
        : Optional[zio.aws.pinpoint.model.ContactCenterActivity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactCenter())
        .map(value => zio.aws.pinpoint.model.ContactCenterActivity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Activity
  ): zio.aws.pinpoint.model.Activity.ReadOnly = new Wrapper(impl)
}
