package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplicationResponse(
    arn: __string,
    id: __string,
    name: __string,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    creationDate: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ApplicationResponse = {
    import ApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
      .builder()
      .arn(arn: java.lang.String)
      .id(id: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ApplicationResponse.ReadOnly =
    zio.aws.pinpoint.model.ApplicationResponse.wrap(buildAwsValue())
}
object ApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ApplicationResponse =
      zio.aws.pinpoint.model.ApplicationResponse(
        arn,
        id,
        name,
        tags.map(value => value),
        creationDate.map(value => value)
      )
    def arn: __string
    def id: __string
    def name: __string
    def tags: Optional[Map[__string, __string]]
    def creationDate: Optional[__string]
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
  ) extends zio.aws.pinpoint.model.ApplicationResponse.ReadOnly {
    override val arn: __string = impl.arn(): __string
    override val id: __string = impl.id(): __string
    override val name: __string = impl.name(): __string
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val creationDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationResponse
  ): zio.aws.pinpoint.model.ApplicationResponse.ReadOnly = new Wrapper(impl)
}
