package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplicationSettingsResource(
    applicationId: __string,
    campaignHook: Optional[zio.aws.pinpoint.model.CampaignHook] =
      Optional.Absent,
    lastModifiedDate: Optional[__string] = Optional.Absent,
    limits: Optional[zio.aws.pinpoint.model.CampaignLimits] = Optional.Absent,
    quietTime: Optional[zio.aws.pinpoint.model.QuietTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource = {
    import ApplicationSettingsResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
      .builder()
      .applicationId(applicationId: java.lang.String)
      .optionallyWith(campaignHook.map(value => value.buildAwsValue()))(
        _.campaignHook
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.String))(
        _.lastModifiedDate
      )
      .optionallyWith(limits.map(value => value.buildAwsValue()))(_.limits)
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly =
    zio.aws.pinpoint.model.ApplicationSettingsResource.wrap(buildAwsValue())
}
object ApplicationSettingsResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ApplicationSettingsResource =
      zio.aws.pinpoint.model.ApplicationSettingsResource(
        applicationId,
        campaignHook.map(value => value.asEditable),
        lastModifiedDate.map(value => value),
        limits.map(value => value.asEditable),
        quietTime.map(value => value.asEditable)
      )
    def applicationId: __string
    def campaignHook: Optional[zio.aws.pinpoint.model.CampaignHook.ReadOnly]
    def lastModifiedDate: Optional[__string]
    def limits: Optional[zio.aws.pinpoint.model.CampaignLimits.ReadOnly]
    def quietTime: Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignHook
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      AwsError.unwrapOptionField("campaignHook", campaignHook)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLimits
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      AwsError.unwrapOptionField("limits", limits)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
  ) extends zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val campaignHook
        : Optional[zio.aws.pinpoint.model.CampaignHook.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaignHook())
        .map(value => zio.aws.pinpoint.model.CampaignHook.wrap(value))
    override val lastModifiedDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: __string)
    override val limits
        : Optional[zio.aws.pinpoint.model.CampaignLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limits())
        .map(value => zio.aws.pinpoint.model.CampaignLimits.wrap(value))
    override val quietTime
        : Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ApplicationSettingsResource
  ): zio.aws.pinpoint.model.ApplicationSettingsResource.ReadOnly = new Wrapper(
    impl
  )
}
