package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait ButtonAction {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.ButtonAction
}
object ButtonAction {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.ButtonAction
  ): zio.aws.pinpoint.model.ButtonAction = value match {
    case software.amazon.awssdk.services.pinpoint.model.ButtonAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.ButtonAction.LINK =>
      val r = LINK
      r
    case software.amazon.awssdk.services.pinpoint.model.ButtonAction.DEEP_LINK =>
      val r = DEEP_LINK
      r
    case software.amazon.awssdk.services.pinpoint.model.ButtonAction.CLOSE =>
      val r = CLOSE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.ButtonAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ButtonAction =
      software.amazon.awssdk.services.pinpoint.model.ButtonAction.UNKNOWN_TO_SDK_VERSION
  }
  case object LINK extends zio.aws.pinpoint.model.ButtonAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ButtonAction =
      software.amazon.awssdk.services.pinpoint.model.ButtonAction.LINK
  }
  case object DEEP_LINK extends zio.aws.pinpoint.model.ButtonAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ButtonAction =
      software.amazon.awssdk.services.pinpoint.model.ButtonAction.DEEP_LINK
  }
  case object CLOSE extends zio.aws.pinpoint.model.ButtonAction {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.ButtonAction =
      software.amazon.awssdk.services.pinpoint.model.ButtonAction.CLOSE
  }
}
