package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CampaignEmailMessage(
    body: Optional[__string] = Optional.Absent,
    fromAddress: Optional[__string] = Optional.Absent,
    htmlBody: Optional[__string] = Optional.Absent,
    title: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage = {
    import CampaignEmailMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(fromAddress.map(value => value: java.lang.String))(
        _.fromAddress
      )
      .optionallyWith(htmlBody.map(value => value: java.lang.String))(
        _.htmlBody
      )
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly =
    zio.aws.pinpoint.model.CampaignEmailMessage.wrap(buildAwsValue())
}
object CampaignEmailMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignEmailMessage =
      zio.aws.pinpoint.model.CampaignEmailMessage(
        body.map(value => value),
        fromAddress.map(value => value),
        htmlBody.map(value => value),
        title.map(value => value)
      )
    def body: Optional[__string]
    def fromAddress: Optional[__string]
    def htmlBody: Optional[__string]
    def title: Optional[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getHtmlBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("htmlBody", htmlBody)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
  ) extends zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val fromAddress: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.fromAddress())
      .map(value => value: __string)
    override val htmlBody: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.htmlBody())
      .map(value => value: __string)
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage
  ): zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly = new Wrapper(impl)
}
