package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CampaignEventFilter(
    dimensions: zio.aws.pinpoint.model.EventDimensions,
    filterType: zio.aws.pinpoint.model.FilterType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignEventFilter = {
    import CampaignEventFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignEventFilter
      .builder()
      .dimensions(dimensions.buildAwsValue())
      .filterType(filterType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly =
    zio.aws.pinpoint.model.CampaignEventFilter.wrap(buildAwsValue())
}
object CampaignEventFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignEventFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignEventFilter =
      zio.aws.pinpoint.model
        .CampaignEventFilter(dimensions.asEditable, filterType)
    def dimensions: zio.aws.pinpoint.model.EventDimensions.ReadOnly
    def filterType: zio.aws.pinpoint.model.FilterType
    def getDimensions
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventDimensions.ReadOnly] =
      ZIO.succeed(dimensions)
    def getFilterType: ZIO[Any, Nothing, zio.aws.pinpoint.model.FilterType] =
      ZIO.succeed(filterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignEventFilter
  ) extends zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly {
    override val dimensions: zio.aws.pinpoint.model.EventDimensions.ReadOnly =
      zio.aws.pinpoint.model.EventDimensions.wrap(impl.dimensions())
    override val filterType: zio.aws.pinpoint.model.FilterType =
      zio.aws.pinpoint.model.FilterType.wrap(impl.filterType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignEventFilter
  ): zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly = new Wrapper(impl)
}
