package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CampaignInAppMessage(
    body: Optional[__string] = Optional.Absent,
    content: Optional[Iterable[zio.aws.pinpoint.model.InAppMessageContent]] =
      Optional.Absent,
    customConfig: Optional[Map[__string, __string]] = Optional.Absent,
    layout: Optional[zio.aws.pinpoint.model.Layout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage = {
    import CampaignInAppMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        content.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.content)
      .optionallyWith(
        customConfig.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.customConfig)
      .optionallyWith(layout.map(value => value.unwrap))(_.layout)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly =
    zio.aws.pinpoint.model.CampaignInAppMessage.wrap(buildAwsValue())
}
object CampaignInAppMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignInAppMessage =
      zio.aws.pinpoint.model.CampaignInAppMessage(
        body.map(value => value),
        content.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customConfig.map(value => value),
        layout.map(value => value)
      )
    def body: Optional[__string]
    def content
        : Optional[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]]
    def customConfig: Optional[Map[__string, __string]]
    def layout: Optional[zio.aws.pinpoint.model.Layout]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getContent: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageContent.ReadOnly
    ]] = AwsError.unwrapOptionField("content", content)
    def getCustomConfig: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("customConfig", customConfig)
    def getLayout: ZIO[Any, AwsError, zio.aws.pinpoint.model.Layout] =
      AwsError.unwrapOptionField("layout", layout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
  ) extends zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val content
        : Optional[List[zio.aws.pinpoint.model.InAppMessageContent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.content())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageContent.wrap(item)
          }.toList
        )
    override val customConfig: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customConfig())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val layout: Optional[zio.aws.pinpoint.model.Layout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layout())
        .map(value => zio.aws.pinpoint.model.Layout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignInAppMessage
  ): zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly = new Wrapper(impl)
}
