package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CampaignState(
    campaignStatus: Optional[zio.aws.pinpoint.model.CampaignStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CampaignState = {
    import CampaignState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CampaignState
      .builder()
      .optionallyWith(campaignStatus.map(value => value.unwrap))(
        _.campaignStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CampaignState.ReadOnly =
    zio.aws.pinpoint.model.CampaignState.wrap(buildAwsValue())
}
object CampaignState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CampaignState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CampaignState =
      zio.aws.pinpoint.model.CampaignState(campaignStatus.map(value => value))
    def campaignStatus: Optional[zio.aws.pinpoint.model.CampaignStatus]
    def getCampaignStatus
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignStatus] =
      AwsError.unwrapOptionField("campaignStatus", campaignStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignState
  ) extends zio.aws.pinpoint.model.CampaignState.ReadOnly {
    override val campaignStatus
        : Optional[zio.aws.pinpoint.model.CampaignStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaignStatus())
        .map(value => zio.aws.pinpoint.model.CampaignStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CampaignState
  ): zio.aws.pinpoint.model.CampaignState.ReadOnly = new Wrapper(impl)
}
