package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ChannelsResponse(
    channels: Map[__string, zio.aws.pinpoint.model.ChannelResponse]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ChannelsResponse = {
    import ChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ChannelsResponse
      .builder()
      .channels(
        channels
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ChannelsResponse.ReadOnly =
    zio.aws.pinpoint.model.ChannelsResponse.wrap(buildAwsValue())
}
object ChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ChannelsResponse =
      zio.aws.pinpoint.model.ChannelsResponse(channels.map({
        case (key, value) =>
          key -> value.asEditable
      }))
    def channels: Map[__string, zio.aws.pinpoint.model.ChannelResponse.ReadOnly]
    def getChannels: ZIO[Any, Nothing, Map[
      __string,
      zio.aws.pinpoint.model.ChannelResponse.ReadOnly
    ]] = ZIO.succeed(channels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ChannelsResponse
  ) extends zio.aws.pinpoint.model.ChannelsResponse.ReadOnly {
    override val channels
        : Map[__string, zio.aws.pinpoint.model.ChannelResponse.ReadOnly] = impl
      .channels()
      .asScala
      .map({ case (key, value) =>
        (key: __string) -> zio.aws.pinpoint.model.ChannelResponse.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ChannelsResponse
  ): zio.aws.pinpoint.model.ChannelsResponse.ReadOnly = new Wrapper(impl)
}
