package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ClosedDays(
    email: Optional[Iterable[zio.aws.pinpoint.model.ClosedDaysRule]] =
      Optional.Absent,
    sms: Optional[Iterable[zio.aws.pinpoint.model.ClosedDaysRule]] =
      Optional.Absent,
    push: Optional[Iterable[zio.aws.pinpoint.model.ClosedDaysRule]] =
      Optional.Absent,
    voice: Optional[Iterable[zio.aws.pinpoint.model.ClosedDaysRule]] =
      Optional.Absent,
    custom: Optional[Iterable[zio.aws.pinpoint.model.ClosedDaysRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ClosedDays = {
    import ClosedDays.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ClosedDays
      .builder()
      .optionallyWith(
        email.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.email)
      .optionallyWith(
        sms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sms)
      .optionallyWith(
        push.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.push)
      .optionallyWith(
        voice.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voice)
      .optionallyWith(
        custom.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.custom)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ClosedDays.ReadOnly =
    zio.aws.pinpoint.model.ClosedDays.wrap(buildAwsValue())
}
object ClosedDays {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ClosedDays
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ClosedDays =
      zio.aws.pinpoint.model.ClosedDays(
        email.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        push.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        voice.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        custom.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def email: Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]]
    def sms: Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]]
    def push: Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]]
    def voice: Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]]
    def custom: Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]]
    def getEmail: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly
    ]] = AwsError.unwrapOptionField("email", email)
    def getSms: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly
    ]] = AwsError.unwrapOptionField("sms", sms)
    def getPush: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly
    ]] = AwsError.unwrapOptionField("push", push)
    def getVoice: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly
    ]] = AwsError.unwrapOptionField("voice", voice)
    def getCustom: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly
    ]] = AwsError.unwrapOptionField("custom", custom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ClosedDays
  ) extends zio.aws.pinpoint.model.ClosedDays.ReadOnly {
    override val email
        : Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.email())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.ClosedDaysRule.wrap(item)
          }.toList
        )
    override val sms
        : Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.ClosedDaysRule.wrap(item)
          }.toList
        )
    override val push
        : Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.push())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.ClosedDaysRule.wrap(item)
          }.toList
        )
    override val voice
        : Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voice())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.ClosedDaysRule.wrap(item)
          }.toList
        )
    override val custom
        : Optional[List[zio.aws.pinpoint.model.ClosedDaysRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.custom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.ClosedDaysRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ClosedDays
  ): zio.aws.pinpoint.model.ClosedDays.ReadOnly = new Wrapper(impl)
}
