package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateAppRequest(
    createApplicationRequest: zio.aws.pinpoint.model.CreateApplicationRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateAppRequest = {
    import CreateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateAppRequest
      .builder()
      .createApplicationRequest(createApplicationRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateAppRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateAppRequest.wrap(buildAwsValue())
}
object CreateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateAppRequest =
      zio.aws.pinpoint.model
        .CreateAppRequest(createApplicationRequest.asEditable)
    def createApplicationRequest
        : zio.aws.pinpoint.model.CreateApplicationRequest.ReadOnly
    def getCreateApplicationRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.CreateApplicationRequest.ReadOnly
    ] = ZIO.succeed(createApplicationRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateAppRequest
  ) extends zio.aws.pinpoint.model.CreateAppRequest.ReadOnly {
    override val createApplicationRequest
        : zio.aws.pinpoint.model.CreateApplicationRequest.ReadOnly =
      zio.aws.pinpoint.model.CreateApplicationRequest
        .wrap(impl.createApplicationRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateAppRequest
  ): zio.aws.pinpoint.model.CreateAppRequest.ReadOnly = new Wrapper(impl)
}
