package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateExportJobRequest(
    applicationId: __string,
    exportJobRequest: zio.aws.pinpoint.model.ExportJobRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest = {
    import CreateExportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .exportJobRequest(exportJobRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateExportJobRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateExportJobRequest.wrap(buildAwsValue())
}
object CreateExportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateExportJobRequest =
      zio.aws.pinpoint.model
        .CreateExportJobRequest(applicationId, exportJobRequest.asEditable)
    def applicationId: __string
    def exportJobRequest: zio.aws.pinpoint.model.ExportJobRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getExportJobRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ExportJobRequest.ReadOnly] =
      ZIO.succeed(exportJobRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest
  ) extends zio.aws.pinpoint.model.CreateExportJobRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val exportJobRequest
        : zio.aws.pinpoint.model.ExportJobRequest.ReadOnly =
      zio.aws.pinpoint.model.ExportJobRequest.wrap(impl.exportJobRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest
  ): zio.aws.pinpoint.model.CreateExportJobRequest.ReadOnly = new Wrapper(impl)
}
