package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateImportJobRequest(
    applicationId: __string,
    importJobRequest: zio.aws.pinpoint.model.ImportJobRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest = {
    import CreateImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .importJobRequest(importJobRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateImportJobRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateImportJobRequest.wrap(buildAwsValue())
}
object CreateImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateImportJobRequest =
      zio.aws.pinpoint.model
        .CreateImportJobRequest(applicationId, importJobRequest.asEditable)
    def applicationId: __string
    def importJobRequest: zio.aws.pinpoint.model.ImportJobRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getImportJobRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ImportJobRequest.ReadOnly] =
      ZIO.succeed(importJobRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest
  ) extends zio.aws.pinpoint.model.CreateImportJobRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val importJobRequest
        : zio.aws.pinpoint.model.ImportJobRequest.ReadOnly =
      zio.aws.pinpoint.model.ImportJobRequest.wrap(impl.importJobRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest
  ): zio.aws.pinpoint.model.CreateImportJobRequest.ReadOnly = new Wrapper(impl)
}
