package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateInAppTemplateRequest(
    inAppTemplateRequest: zio.aws.pinpoint.model.InAppTemplateRequest,
    templateName: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest = {
    import CreateInAppTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest
      .builder()
      .inAppTemplateRequest(inAppTemplateRequest.buildAwsValue())
      .templateName(templateName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.CreateInAppTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.CreateInAppTemplateRequest.wrap(buildAwsValue())
}
object CreateInAppTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateInAppTemplateRequest =
      zio.aws.pinpoint.model.CreateInAppTemplateRequest(
        inAppTemplateRequest.asEditable,
        templateName
      )
    def inAppTemplateRequest
        : zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly
    def templateName: __string
    def getInAppTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly
    ] = ZIO.succeed(inAppTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest
  ) extends zio.aws.pinpoint.model.CreateInAppTemplateRequest.ReadOnly {
    override val inAppTemplateRequest
        : zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.InAppTemplateRequest
        .wrap(impl.inAppTemplateRequest())
    override val templateName: __string = impl.templateName(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateInAppTemplateRequest
  ): zio.aws.pinpoint.model.CreateInAppTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
