package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateRecommenderConfiguration(
    attributes: Optional[Map[__string, __string]] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    recommendationProviderIdType: Optional[__string] = Optional.Absent,
    recommendationProviderRoleArn: __string,
    recommendationProviderUri: __string,
    recommendationTransformerUri: Optional[__string] = Optional.Absent,
    recommendationsDisplayName: Optional[__string] = Optional.Absent,
    recommendationsPerMessage: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfiguration = {
    import CreateRecommenderConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfiguration
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        recommendationProviderIdType.map(value => value: java.lang.String)
      )(_.recommendationProviderIdType)
      .recommendationProviderRoleArn(
        recommendationProviderRoleArn: java.lang.String
      )
      .recommendationProviderUri(recommendationProviderUri: java.lang.String)
      .optionallyWith(
        recommendationTransformerUri.map(value => value: java.lang.String)
      )(_.recommendationTransformerUri)
      .optionallyWith(
        recommendationsDisplayName.map(value => value: java.lang.String)
      )(_.recommendationsDisplayName)
      .optionallyWith(recommendationsPerMessage.map(value => value: Integer))(
        _.recommendationsPerMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.CreateRecommenderConfiguration.ReadOnly =
    zio.aws.pinpoint.model.CreateRecommenderConfiguration.wrap(buildAwsValue())
}
object CreateRecommenderConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.CreateRecommenderConfiguration =
      zio.aws.pinpoint.model.CreateRecommenderConfiguration(
        attributes.map(value => value),
        description.map(value => value),
        name.map(value => value),
        recommendationProviderIdType.map(value => value),
        recommendationProviderRoleArn,
        recommendationProviderUri,
        recommendationTransformerUri.map(value => value),
        recommendationsDisplayName.map(value => value),
        recommendationsPerMessage.map(value => value)
      )
    def attributes: Optional[Map[__string, __string]]
    def description: Optional[__string]
    def name: Optional[__string]
    def recommendationProviderIdType: Optional[__string]
    def recommendationProviderRoleArn: __string
    def recommendationProviderUri: __string
    def recommendationTransformerUri: Optional[__string]
    def recommendationsDisplayName: Optional[__string]
    def recommendationsPerMessage: Optional[__integer]
    def getAttributes: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRecommendationProviderIdType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "recommendationProviderIdType",
        recommendationProviderIdType
      )
    def getRecommendationProviderRoleArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(recommendationProviderRoleArn)
    def getRecommendationProviderUri: ZIO[Any, Nothing, __string] =
      ZIO.succeed(recommendationProviderUri)
    def getRecommendationTransformerUri: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "recommendationTransformerUri",
        recommendationTransformerUri
      )
    def getRecommendationsDisplayName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "recommendationsDisplayName",
        recommendationsDisplayName
      )
    def getRecommendationsPerMessage: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("recommendationsPerMessage", recommendationsPerMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfiguration
  ) extends zio.aws.pinpoint.model.CreateRecommenderConfiguration.ReadOnly {
    override val attributes: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val recommendationProviderIdType: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationProviderIdType())
        .map(value => value: __string)
    override val recommendationProviderRoleArn: __string =
      impl.recommendationProviderRoleArn(): __string
    override val recommendationProviderUri: __string =
      impl.recommendationProviderUri(): __string
    override val recommendationTransformerUri: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationTransformerUri())
        .map(value => value: __string)
    override val recommendationsDisplayName: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationsDisplayName())
        .map(value => value: __string)
    override val recommendationsPerMessage: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationsPerMessage())
        .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfiguration
  ): zio.aws.pinpoint.model.CreateRecommenderConfiguration.ReadOnly =
    new Wrapper(impl)
}
