package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultMessage(
    body: Optional[__string] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DefaultMessage = {
    import DefaultMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DefaultMessage
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DefaultMessage.ReadOnly =
    zio.aws.pinpoint.model.DefaultMessage.wrap(buildAwsValue())
}
object DefaultMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DefaultMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DefaultMessage =
      zio.aws.pinpoint.model.DefaultMessage(
        body.map(value => value),
        substitutions.map(value => value)
      )
    def body: Optional[__string]
    def substitutions: Optional[Map[__string, List[__string]]]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultMessage
  ) extends zio.aws.pinpoint.model.DefaultMessage.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultMessage
  ): zio.aws.pinpoint.model.DefaultMessage.ReadOnly = new Wrapper(impl)
}
