package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultPushNotificationMessage(
    action: Optional[zio.aws.pinpoint.model.Action] = Optional.Absent,
    body: Optional[__string] = Optional.Absent,
    data: Optional[Map[__string, __string]] = Optional.Absent,
    silentPush: Optional[__boolean] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    title: Optional[__string] = Optional.Absent,
    url: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage = {
    import DefaultPushNotificationMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.data)
      .optionallyWith(silentPush.map(value => value: java.lang.Boolean))(
        _.silentPush
      )
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly =
    zio.aws.pinpoint.model.DefaultPushNotificationMessage.wrap(buildAwsValue())
}
object DefaultPushNotificationMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DefaultPushNotificationMessage =
      zio.aws.pinpoint.model.DefaultPushNotificationMessage(
        action.map(value => value),
        body.map(value => value),
        data.map(value => value),
        silentPush.map(value => value),
        substitutions.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Optional[zio.aws.pinpoint.model.Action]
    def body: Optional[__string]
    def data: Optional[Map[__string, __string]]
    def silentPush: Optional[__boolean]
    def substitutions: Optional[Map[__string, List[__string]]]
    def title: Optional[__string]
    def url: Optional[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getData: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("data", data)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
  ) extends zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly {
    override val action: Optional[zio.aws.pinpoint.model.Action] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val data: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val silentPush: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.silentPush())
      .map(value => value: __boolean)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DefaultPushNotificationMessage
  ): zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly =
    new Wrapper(impl)
}
