package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCampaignResponse(
    campaignResponse: zio.aws.pinpoint.model.CampaignResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse = {
    import DeleteCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse
      .builder()
      .campaignResponse(campaignResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteCampaignResponse.wrap(buildAwsValue())
}
object DeleteCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteCampaignResponse =
      zio.aws.pinpoint.model.DeleteCampaignResponse(campaignResponse.asEditable)
    def campaignResponse: zio.aws.pinpoint.model.CampaignResponse.ReadOnly
    def getCampaignResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.CampaignResponse.ReadOnly] =
      ZIO.succeed(campaignResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse
  ) extends zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly {
    override val campaignResponse
        : zio.aws.pinpoint.model.CampaignResponse.ReadOnly =
      zio.aws.pinpoint.model.CampaignResponse.wrap(impl.campaignResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse
  ): zio.aws.pinpoint.model.DeleteCampaignResponse.ReadOnly = new Wrapper(impl)
}
