package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEndpointResponse(
    endpointResponse: zio.aws.pinpoint.model.EndpointResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse = {
    import DeleteEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse
      .builder()
      .endpointResponse(endpointResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteEndpointResponse.wrap(buildAwsValue())
}
object DeleteEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteEndpointResponse =
      zio.aws.pinpoint.model.DeleteEndpointResponse(endpointResponse.asEditable)
    def endpointResponse: zio.aws.pinpoint.model.EndpointResponse.ReadOnly
    def getEndpointResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EndpointResponse.ReadOnly] =
      ZIO.succeed(endpointResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse
  ) extends zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly {
    override val endpointResponse
        : zio.aws.pinpoint.model.EndpointResponse.ReadOnly =
      zio.aws.pinpoint.model.EndpointResponse.wrap(impl.endpointResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse
  ): zio.aws.pinpoint.model.DeleteEndpointResponse.ReadOnly = new Wrapper(impl)
}
