package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteEventStreamResponse(
    eventStream: zio.aws.pinpoint.model.EventStream
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse = {
    import DeleteEventStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse
      .builder()
      .eventStream(eventStream.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly =
    zio.aws.pinpoint.model.DeleteEventStreamResponse.wrap(buildAwsValue())
}
object DeleteEventStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteEventStreamResponse =
      zio.aws.pinpoint.model.DeleteEventStreamResponse(eventStream.asEditable)
    def eventStream: zio.aws.pinpoint.model.EventStream.ReadOnly
    def getEventStream
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventStream.ReadOnly] =
      ZIO.succeed(eventStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse
  ) extends zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly {
    override val eventStream: zio.aws.pinpoint.model.EventStream.ReadOnly =
      zio.aws.pinpoint.model.EventStream.wrap(impl.eventStream())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse
  ): zio.aws.pinpoint.model.DeleteEventStreamResponse.ReadOnly = new Wrapper(
    impl
  )
}
