package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteInAppTemplateRequest(
    templateName: __string,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest = {
    import DeleteInAppTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest
      .builder()
      .templateName(templateName: java.lang.String)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DeleteInAppTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.DeleteInAppTemplateRequest.wrap(buildAwsValue())
}
object DeleteInAppTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DeleteInAppTemplateRequest =
      zio.aws.pinpoint.model
        .DeleteInAppTemplateRequest(templateName, version.map(value => value))
    def templateName: __string
    def version: Optional[__string]
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest
  ) extends zio.aws.pinpoint.model.DeleteInAppTemplateRequest.ReadOnly {
    override val templateName: __string = impl.templateName(): __string
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DeleteInAppTemplateRequest
  ): zio.aws.pinpoint.model.DeleteInAppTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
