package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait DeliveryStatus {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.DeliveryStatus
}
object DeliveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.DeliveryStatus
  ): zio.aws.pinpoint.model.DeliveryStatus = value match {
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.SUCCESSFUL =>
      val r = SUCCESSFUL
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.THROTTLED =>
      val r = THROTTLED
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.TEMPORARY_FAILURE =>
      val r = TEMPORARY_FAILURE
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.PERMANENT_FAILURE =>
      val r = PERMANENT_FAILURE
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.UNKNOWN_FAILURE =>
      val r = UNKNOWN_FAILURE
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.OPT_OUT =>
      val r = OPT_OUT
      r
    case software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.DUPLICATE =>
      val r = DUPLICATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESSFUL extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.SUCCESSFUL
  }
  case object THROTTLED extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.THROTTLED
  }
  case object TEMPORARY_FAILURE extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.TEMPORARY_FAILURE
  }
  case object PERMANENT_FAILURE extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.PERMANENT_FAILURE
  }
  case object UNKNOWN_FAILURE extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.UNKNOWN_FAILURE
  }
  case object OPT_OUT extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.OPT_OUT
  }
  case object DUPLICATE extends zio.aws.pinpoint.model.DeliveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DeliveryStatus =
      software.amazon.awssdk.services.pinpoint.model.DeliveryStatus.DUPLICATE
  }
}
