package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait DimensionType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.DimensionType
}
object DimensionType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.DimensionType
  ): zio.aws.pinpoint.model.DimensionType = value match {
    case software.amazon.awssdk.services.pinpoint.model.DimensionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.DimensionType.INCLUSIVE =>
      val r = INCLUSIVE
      r
    case software.amazon.awssdk.services.pinpoint.model.DimensionType.EXCLUSIVE =>
      val r = EXCLUSIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.DimensionType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DimensionType =
      software.amazon.awssdk.services.pinpoint.model.DimensionType.UNKNOWN_TO_SDK_VERSION
  }
  case object INCLUSIVE extends zio.aws.pinpoint.model.DimensionType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DimensionType =
      software.amazon.awssdk.services.pinpoint.model.DimensionType.INCLUSIVE
  }
  case object EXCLUSIVE extends zio.aws.pinpoint.model.DimensionType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.DimensionType =
      software.amazon.awssdk.services.pinpoint.model.DimensionType.EXCLUSIVE
  }
}
