package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DirectMessageConfiguration(
    admMessage: Optional[zio.aws.pinpoint.model.ADMMessage] = Optional.Absent,
    apnsMessage: Optional[zio.aws.pinpoint.model.APNSMessage] = Optional.Absent,
    baiduMessage: Optional[zio.aws.pinpoint.model.BaiduMessage] =
      Optional.Absent,
    defaultMessage: Optional[zio.aws.pinpoint.model.DefaultMessage] =
      Optional.Absent,
    defaultPushNotificationMessage: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationMessage
    ] = Optional.Absent,
    emailMessage: Optional[zio.aws.pinpoint.model.EmailMessage] =
      Optional.Absent,
    gcmMessage: Optional[zio.aws.pinpoint.model.GCMMessage] = Optional.Absent,
    smsMessage: Optional[zio.aws.pinpoint.model.SMSMessage] = Optional.Absent,
    voiceMessage: Optional[zio.aws.pinpoint.model.VoiceMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration = {
    import DirectMessageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
      .builder()
      .optionallyWith(admMessage.map(value => value.buildAwsValue()))(
        _.admMessage
      )
      .optionallyWith(apnsMessage.map(value => value.buildAwsValue()))(
        _.apnsMessage
      )
      .optionallyWith(baiduMessage.map(value => value.buildAwsValue()))(
        _.baiduMessage
      )
      .optionallyWith(defaultMessage.map(value => value.buildAwsValue()))(
        _.defaultMessage
      )
      .optionallyWith(
        defaultPushNotificationMessage.map(value => value.buildAwsValue())
      )(_.defaultPushNotificationMessage)
      .optionallyWith(emailMessage.map(value => value.buildAwsValue()))(
        _.emailMessage
      )
      .optionallyWith(gcmMessage.map(value => value.buildAwsValue()))(
        _.gcmMessage
      )
      .optionallyWith(smsMessage.map(value => value.buildAwsValue()))(
        _.smsMessage
      )
      .optionallyWith(voiceMessage.map(value => value.buildAwsValue()))(
        _.voiceMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly =
    zio.aws.pinpoint.model.DirectMessageConfiguration.wrap(buildAwsValue())
}
object DirectMessageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.DirectMessageConfiguration =
      zio.aws.pinpoint.model.DirectMessageConfiguration(
        admMessage.map(value => value.asEditable),
        apnsMessage.map(value => value.asEditable),
        baiduMessage.map(value => value.asEditable),
        defaultMessage.map(value => value.asEditable),
        defaultPushNotificationMessage.map(value => value.asEditable),
        emailMessage.map(value => value.asEditable),
        gcmMessage.map(value => value.asEditable),
        smsMessage.map(value => value.asEditable),
        voiceMessage.map(value => value.asEditable)
      )
    def admMessage: Optional[zio.aws.pinpoint.model.ADMMessage.ReadOnly]
    def apnsMessage: Optional[zio.aws.pinpoint.model.APNSMessage.ReadOnly]
    def baiduMessage: Optional[zio.aws.pinpoint.model.BaiduMessage.ReadOnly]
    def defaultMessage: Optional[zio.aws.pinpoint.model.DefaultMessage.ReadOnly]
    def defaultPushNotificationMessage: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly
    ]
    def emailMessage: Optional[zio.aws.pinpoint.model.EmailMessage.ReadOnly]
    def gcmMessage: Optional[zio.aws.pinpoint.model.GCMMessage.ReadOnly]
    def smsMessage: Optional[zio.aws.pinpoint.model.SMSMessage.ReadOnly]
    def voiceMessage: Optional[zio.aws.pinpoint.model.VoiceMessage.ReadOnly]
    def getAdmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.ADMMessage.ReadOnly] =
      AwsError.unwrapOptionField("admMessage", admMessage)
    def getApnsMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.APNSMessage.ReadOnly] =
      AwsError.unwrapOptionField("apnsMessage", apnsMessage)
    def getBaiduMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.BaiduMessage.ReadOnly] =
      AwsError.unwrapOptionField("baiduMessage", baiduMessage)
    def getDefaultMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.DefaultMessage.ReadOnly] =
      AwsError.unwrapOptionField("defaultMessage", defaultMessage)
    def getDefaultPushNotificationMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultPushNotificationMessage",
      defaultPushNotificationMessage
    )
    def getEmailMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EmailMessage.ReadOnly] =
      AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getGcmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.GCMMessage.ReadOnly] =
      AwsError.unwrapOptionField("gcmMessage", gcmMessage)
    def getSmsMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SMSMessage.ReadOnly] =
      AwsError.unwrapOptionField("smsMessage", smsMessage)
    def getVoiceMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.VoiceMessage.ReadOnly] =
      AwsError.unwrapOptionField("voiceMessage", voiceMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
  ) extends zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly {
    override val admMessage
        : Optional[zio.aws.pinpoint.model.ADMMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.admMessage())
        .map(value => zio.aws.pinpoint.model.ADMMessage.wrap(value))
    override val apnsMessage
        : Optional[zio.aws.pinpoint.model.APNSMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apnsMessage())
        .map(value => zio.aws.pinpoint.model.APNSMessage.wrap(value))
    override val baiduMessage
        : Optional[zio.aws.pinpoint.model.BaiduMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baiduMessage())
        .map(value => zio.aws.pinpoint.model.BaiduMessage.wrap(value))
    override val defaultMessage
        : Optional[zio.aws.pinpoint.model.DefaultMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultMessage())
        .map(value => zio.aws.pinpoint.model.DefaultMessage.wrap(value))
    override val defaultPushNotificationMessage: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationMessage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultPushNotificationMessage())
      .map(value =>
        zio.aws.pinpoint.model.DefaultPushNotificationMessage.wrap(value)
      )
    override val emailMessage
        : Optional[zio.aws.pinpoint.model.EmailMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailMessage())
        .map(value => zio.aws.pinpoint.model.EmailMessage.wrap(value))
    override val gcmMessage
        : Optional[zio.aws.pinpoint.model.GCMMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gcmMessage())
        .map(value => zio.aws.pinpoint.model.GCMMessage.wrap(value))
    override val smsMessage
        : Optional[zio.aws.pinpoint.model.SMSMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsMessage())
        .map(value => zio.aws.pinpoint.model.SMSMessage.wrap(value))
    override val voiceMessage
        : Optional[zio.aws.pinpoint.model.VoiceMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceMessage())
        .map(value => zio.aws.pinpoint.model.VoiceMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration
  ): zio.aws.pinpoint.model.DirectMessageConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
