package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EmailChannelResponse(
    applicationId: Optional[__string] = Optional.Absent,
    configurationSet: Optional[__string] = Optional.Absent,
    creationDate: Optional[__string] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent,
    fromAddress: Optional[__string] = Optional.Absent,
    hasCredential: Optional[__boolean] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    identity: Optional[__string] = Optional.Absent,
    isArchived: Optional[__boolean] = Optional.Absent,
    lastModifiedBy: Optional[__string] = Optional.Absent,
    lastModifiedDate: Optional[__string] = Optional.Absent,
    messagesPerSecond: Optional[__integer] = Optional.Absent,
    platform: __string,
    roleArn: Optional[__string] = Optional.Absent,
    version: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse = {
    import EmailChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
      .builder()
      .optionallyWith(applicationId.map(value => value: java.lang.String))(
        _.applicationId
      )
      .optionallyWith(configurationSet.map(value => value: java.lang.String))(
        _.configurationSet
      )
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(fromAddress.map(value => value: java.lang.String))(
        _.fromAddress
      )
      .optionallyWith(hasCredential.map(value => value: java.lang.Boolean))(
        _.hasCredential
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(identity.map(value => value: java.lang.String))(
        _.identity
      )
      .optionallyWith(isArchived.map(value => value: java.lang.Boolean))(
        _.isArchived
      )
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.String))(
        _.lastModifiedDate
      )
      .optionallyWith(messagesPerSecond.map(value => value: Integer))(
        _.messagesPerSecond
      )
      .platform(platform: java.lang.String)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(version.map(value => value: Integer))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.EmailChannelResponse.wrap(buildAwsValue())
}
object EmailChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailChannelResponse =
      zio.aws.pinpoint.model.EmailChannelResponse(
        applicationId.map(value => value),
        configurationSet.map(value => value),
        creationDate.map(value => value),
        enabled.map(value => value),
        fromAddress.map(value => value),
        hasCredential.map(value => value),
        id.map(value => value),
        identity.map(value => value),
        isArchived.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        messagesPerSecond.map(value => value),
        platform,
        roleArn.map(value => value),
        version.map(value => value)
      )
    def applicationId: Optional[__string]
    def configurationSet: Optional[__string]
    def creationDate: Optional[__string]
    def enabled: Optional[__boolean]
    def fromAddress: Optional[__string]
    def hasCredential: Optional[__boolean]
    def id: Optional[__string]
    def identity: Optional[__string]
    def isArchived: Optional[__boolean]
    def lastModifiedBy: Optional[__string]
    def lastModifiedDate: Optional[__string]
    def messagesPerSecond: Optional[__integer]
    def platform: __string
    def roleArn: Optional[__string]
    def version: Optional[__integer]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getConfigurationSet: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("configurationSet", configurationSet)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getHasCredential: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("hasCredential", hasCredential)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIdentity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("identity", identity)
    def getIsArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("messagesPerSecond", messagesPerSecond)
    def getPlatform: ZIO[Any, Nothing, __string] = ZIO.succeed(platform)
    def getRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
  ) extends zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly {
    override val applicationId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => value: __string)
    override val configurationSet: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSet())
      .map(value => value: __string)
    override val creationDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: __string)
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val fromAddress: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.fromAddress())
      .map(value => value: __string)
    override val hasCredential: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasCredential())
      .map(value => value: __boolean)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val identity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.identity())
      .map(value => value: __string)
    override val isArchived: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isArchived())
      .map(value => value: __boolean)
    override val lastModifiedBy: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: __string)
    override val lastModifiedDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: __string)
    override val messagesPerSecond: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.messagesPerSecond())
      .map(value => value: __integer)
    override val platform: __string = impl.platform(): __string
    override val roleArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => value: __string)
    override val version: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailChannelResponse
  ): zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly = new Wrapper(impl)
}
