package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EmailMessage(
    body: Optional[__string] = Optional.Absent,
    feedbackForwardingAddress: Optional[__string] = Optional.Absent,
    fromAddress: Optional[__string] = Optional.Absent,
    rawEmail: Optional[zio.aws.pinpoint.model.RawEmail] = Optional.Absent,
    replyToAddresses: Optional[Iterable[__string]] = Optional.Absent,
    simpleEmail: Optional[zio.aws.pinpoint.model.SimpleEmail] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EmailMessage = {
    import EmailMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EmailMessage
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        feedbackForwardingAddress.map(value => value: java.lang.String)
      )(_.feedbackForwardingAddress)
      .optionallyWith(fromAddress.map(value => value: java.lang.String))(
        _.fromAddress
      )
      .optionallyWith(rawEmail.map(value => value.buildAwsValue()))(_.rawEmail)
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(simpleEmail.map(value => value.buildAwsValue()))(
        _.simpleEmail
      )
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EmailMessage.ReadOnly =
    zio.aws.pinpoint.model.EmailMessage.wrap(buildAwsValue())
}
object EmailMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EmailMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EmailMessage =
      zio.aws.pinpoint.model.EmailMessage(
        body.map(value => value),
        feedbackForwardingAddress.map(value => value),
        fromAddress.map(value => value),
        rawEmail.map(value => value.asEditable),
        replyToAddresses.map(value => value),
        simpleEmail.map(value => value.asEditable),
        substitutions.map(value => value)
      )
    def body: Optional[__string]
    def feedbackForwardingAddress: Optional[__string]
    def fromAddress: Optional[__string]
    def rawEmail: Optional[zio.aws.pinpoint.model.RawEmail.ReadOnly]
    def replyToAddresses: Optional[List[__string]]
    def simpleEmail: Optional[zio.aws.pinpoint.model.SimpleEmail.ReadOnly]
    def substitutions: Optional[Map[__string, List[__string]]]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getFeedbackForwardingAddress: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("feedbackForwardingAddress", feedbackForwardingAddress)
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
    def getRawEmail
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.RawEmail.ReadOnly] =
      AwsError.unwrapOptionField("rawEmail", rawEmail)
    def getReplyToAddresses: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getSimpleEmail
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SimpleEmail.ReadOnly] =
      AwsError.unwrapOptionField("simpleEmail", simpleEmail)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailMessage
  ) extends zio.aws.pinpoint.model.EmailMessage.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val feedbackForwardingAddress: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.feedbackForwardingAddress())
        .map(value => value: __string)
    override val fromAddress: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.fromAddress())
      .map(value => value: __string)
    override val rawEmail: Optional[zio.aws.pinpoint.model.RawEmail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rawEmail())
        .map(value => zio.aws.pinpoint.model.RawEmail.wrap(value))
    override val replyToAddresses: Optional[List[__string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replyToAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: __string
          }.toList
        )
    override val simpleEmail
        : Optional[zio.aws.pinpoint.model.SimpleEmail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.simpleEmail())
        .map(value => zio.aws.pinpoint.model.SimpleEmail.wrap(value))
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EmailMessage
  ): zio.aws.pinpoint.model.EmailMessage.ReadOnly = new Wrapper(impl)
}
