package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EndpointItemResponse(
    message: Optional[__string] = Optional.Absent,
    statusCode: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse = {
    import EndpointItemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(statusCode.map(value => value: Integer))(_.statusCode)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly =
    zio.aws.pinpoint.model.EndpointItemResponse.wrap(buildAwsValue())
}
object EndpointItemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointItemResponse =
      zio.aws.pinpoint.model.EndpointItemResponse(
        message.map(value => value),
        statusCode.map(value => value)
      )
    def message: Optional[__string]
    def statusCode: Optional[__integer]
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getStatusCode: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("statusCode", statusCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse
  ) extends zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly {
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
    override val statusCode: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointItemResponse
  ): zio.aws.pinpoint.model.EndpointItemResponse.ReadOnly = new Wrapper(impl)
}
