package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__double, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointLocation(
    city: Optional[__string] = Optional.Absent,
    country: Optional[__string] = Optional.Absent,
    latitude: Optional[__double] = Optional.Absent,
    longitude: Optional[__double] = Optional.Absent,
    postalCode: Optional[__string] = Optional.Absent,
    region: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointLocation = {
    import EndpointLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointLocation
      .builder()
      .optionallyWith(city.map(value => value: java.lang.String))(_.city)
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .optionallyWith(latitude.map(value => value: java.lang.Double))(
        _.latitude
      )
      .optionallyWith(longitude.map(value => value: java.lang.Double))(
        _.longitude
      )
      .optionallyWith(postalCode.map(value => value: java.lang.String))(
        _.postalCode
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointLocation.ReadOnly =
    zio.aws.pinpoint.model.EndpointLocation.wrap(buildAwsValue())
}
object EndpointLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointLocation =
      zio.aws.pinpoint.model.EndpointLocation(
        city.map(value => value),
        country.map(value => value),
        latitude.map(value => value),
        longitude.map(value => value),
        postalCode.map(value => value),
        region.map(value => value)
      )
    def city: Optional[__string]
    def country: Optional[__string]
    def latitude: Optional[__double]
    def longitude: Optional[__double]
    def postalCode: Optional[__string]
    def region: Optional[__string]
    def getCity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("city", city)
    def getCountry: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("country", country)
    def getLatitude: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("latitude", latitude)
    def getLongitude: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("longitude", longitude)
    def getPostalCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointLocation
  ) extends zio.aws.pinpoint.model.EndpointLocation.ReadOnly {
    override val city: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.city())
      .map(value => value: __string)
    override val country: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => value: __string)
    override val latitude: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.latitude())
      .map(value => value: __double)
    override val longitude: Optional[__double] = zio.aws.core.internal
      .optionalFromNullable(impl.longitude())
      .map(value => value: __double)
    override val postalCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.postalCode())
      .map(value => value: __string)
    override val region: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointLocation
  ): zio.aws.pinpoint.model.EndpointLocation.ReadOnly = new Wrapper(impl)
}
