package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__double, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointRequest(
    address: Optional[__string] = Optional.Absent,
    attributes: Optional[Map[__string, Iterable[__string]]] = Optional.Absent,
    channelType: Optional[zio.aws.pinpoint.model.ChannelType] = Optional.Absent,
    demographic: Optional[zio.aws.pinpoint.model.EndpointDemographic] =
      Optional.Absent,
    effectiveDate: Optional[__string] = Optional.Absent,
    endpointStatus: Optional[__string] = Optional.Absent,
    location: Optional[zio.aws.pinpoint.model.EndpointLocation] =
      Optional.Absent,
    metrics: Optional[Map[__string, __double]] = Optional.Absent,
    optOut: Optional[__string] = Optional.Absent,
    requestId: Optional[__string] = Optional.Absent,
    user: Optional[zio.aws.pinpoint.model.EndpointUser] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EndpointRequest = {
    import EndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EndpointRequest
      .builder()
      .optionallyWith(address.map(value => value: java.lang.String))(_.address)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(channelType.map(value => value.unwrap))(_.channelType)
      .optionallyWith(demographic.map(value => value.buildAwsValue()))(
        _.demographic
      )
      .optionallyWith(effectiveDate.map(value => value: java.lang.String))(
        _.effectiveDate
      )
      .optionallyWith(endpointStatus.map(value => value: java.lang.String))(
        _.endpointStatus
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Double)
            })
            .asJava
        )
      )(_.metrics)
      .optionallyWith(optOut.map(value => value: java.lang.String))(_.optOut)
      .optionallyWith(requestId.map(value => value: java.lang.String))(
        _.requestId
      )
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EndpointRequest.ReadOnly =
    zio.aws.pinpoint.model.EndpointRequest.wrap(buildAwsValue())
}
object EndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EndpointRequest =
      zio.aws.pinpoint.model.EndpointRequest(
        address.map(value => value),
        attributes.map(value => value),
        channelType.map(value => value),
        demographic.map(value => value.asEditable),
        effectiveDate.map(value => value),
        endpointStatus.map(value => value),
        location.map(value => value.asEditable),
        metrics.map(value => value),
        optOut.map(value => value),
        requestId.map(value => value),
        user.map(value => value.asEditable)
      )
    def address: Optional[__string]
    def attributes: Optional[Map[__string, List[__string]]]
    def channelType: Optional[zio.aws.pinpoint.model.ChannelType]
    def demographic
        : Optional[zio.aws.pinpoint.model.EndpointDemographic.ReadOnly]
    def effectiveDate: Optional[__string]
    def endpointStatus: Optional[__string]
    def location: Optional[zio.aws.pinpoint.model.EndpointLocation.ReadOnly]
    def metrics: Optional[Map[__string, __double]]
    def optOut: Optional[__string]
    def requestId: Optional[__string]
    def user: Optional[zio.aws.pinpoint.model.EndpointUser.ReadOnly]
    def getAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("address", address)
    def getAttributes: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getChannelType: ZIO[Any, AwsError, zio.aws.pinpoint.model.ChannelType] =
      AwsError.unwrapOptionField("channelType", channelType)
    def getDemographic: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EndpointDemographic.ReadOnly
    ] = AwsError.unwrapOptionField("demographic", demographic)
    def getEffectiveDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("effectiveDate", effectiveDate)
    def getEndpointStatus: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endpointStatus", endpointStatus)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EndpointLocation.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getMetrics: ZIO[Any, AwsError, Map[__string, __double]] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getOptOut: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("optOut", optOut)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getUser
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EndpointUser.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointRequest
  ) extends zio.aws.pinpoint.model.EndpointRequest.ReadOnly {
    override val address: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value => value: __string)
    override val attributes: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val channelType: Optional[zio.aws.pinpoint.model.ChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelType())
        .map(value => zio.aws.pinpoint.model.ChannelType.wrap(value))
    override val demographic
        : Optional[zio.aws.pinpoint.model.EndpointDemographic.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.demographic())
        .map(value => zio.aws.pinpoint.model.EndpointDemographic.wrap(value))
    override val effectiveDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveDate())
      .map(value => value: __string)
    override val endpointStatus: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointStatus())
      .map(value => value: __string)
    override val location
        : Optional[zio.aws.pinpoint.model.EndpointLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.pinpoint.model.EndpointLocation.wrap(value))
    override val metrics: Optional[Map[__string, __double]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __double)
            })
            .toMap
        )
    override val optOut: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.optOut())
      .map(value => value: __string)
    override val requestId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => value: __string)
    override val user: Optional[zio.aws.pinpoint.model.EndpointUser.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.pinpoint.model.EndpointUser.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EndpointRequest
  ): zio.aws.pinpoint.model.EndpointRequest.ReadOnly = new Wrapper(impl)
}
