package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait EndpointTypesElement {
  def unwrap
      : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement
}
object EndpointTypesElement {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement
  ): zio.aws.pinpoint.model.EndpointTypesElement = value match {
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.PUSH =>
      val r = PUSH
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.GCM =>
      val r = GCM
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS =>
      val r = APNS
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS_SANDBOX =>
      val r = APNS_SANDBOX
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS_VOIP =>
      val r = APNS_VOIP
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS_VOIP_SANDBOX =>
      val r = APNS_VOIP_SANDBOX
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.ADM =>
      val r = ADM
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.VOICE =>
      val r = VOICE
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.BAIDU =>
      val r = BAIDU
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.IN_APP =>
      val r = IN_APP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.UNKNOWN_TO_SDK_VERSION
  }
  case object PUSH extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.PUSH
  }
  case object GCM extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.GCM
  }
  case object APNS extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS
  }
  case object APNS_SANDBOX extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS_SANDBOX
  }
  case object APNS_VOIP extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS_VOIP
  }
  case object APNS_VOIP_SANDBOX
      extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.APNS_VOIP_SANDBOX
  }
  case object ADM extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.ADM
  }
  case object SMS extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.SMS
  }
  case object VOICE extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.VOICE
  }
  case object EMAIL extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.EMAIL
  }
  case object BAIDU extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.BAIDU
  }
  case object CUSTOM extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.CUSTOM
  }
  case object IN_APP extends zio.aws.pinpoint.model.EndpointTypesElement {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement =
      software.amazon.awssdk.services.pinpoint.model.EndpointTypesElement.IN_APP
  }
}
