package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__double, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Event(
    appPackageName: Optional[__string] = Optional.Absent,
    appTitle: Optional[__string] = Optional.Absent,
    appVersionCode: Optional[__string] = Optional.Absent,
    attributes: Optional[Map[__string, __string]] = Optional.Absent,
    clientSdkVersion: Optional[__string] = Optional.Absent,
    eventType: __string,
    metrics: Optional[Map[__string, __double]] = Optional.Absent,
    sdkName: Optional[__string] = Optional.Absent,
    session: Optional[zio.aws.pinpoint.model.Session] = Optional.Absent,
    timestamp: __string
) {
  def buildAwsValue(): software.amazon.awssdk.services.pinpoint.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Event
      .builder()
      .optionallyWith(appPackageName.map(value => value: java.lang.String))(
        _.appPackageName
      )
      .optionallyWith(appTitle.map(value => value: java.lang.String))(
        _.appTitle
      )
      .optionallyWith(appVersionCode.map(value => value: java.lang.String))(
        _.appVersionCode
      )
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(clientSdkVersion.map(value => value: java.lang.String))(
        _.clientSdkVersion
      )
      .eventType(eventType: java.lang.String)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Double)
            })
            .asJava
        )
      )(_.metrics)
      .optionallyWith(sdkName.map(value => value: java.lang.String))(_.sdkName)
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .timestamp(timestamp: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Event.ReadOnly =
    zio.aws.pinpoint.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Event = zio.aws.pinpoint.model.Event(
      appPackageName.map(value => value),
      appTitle.map(value => value),
      appVersionCode.map(value => value),
      attributes.map(value => value),
      clientSdkVersion.map(value => value),
      eventType,
      metrics.map(value => value),
      sdkName.map(value => value),
      session.map(value => value.asEditable),
      timestamp
    )
    def appPackageName: Optional[__string]
    def appTitle: Optional[__string]
    def appVersionCode: Optional[__string]
    def attributes: Optional[Map[__string, __string]]
    def clientSdkVersion: Optional[__string]
    def eventType: __string
    def metrics: Optional[Map[__string, __double]]
    def sdkName: Optional[__string]
    def session: Optional[zio.aws.pinpoint.model.Session.ReadOnly]
    def timestamp: __string
    def getAppPackageName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appPackageName", appPackageName)
    def getAppTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appTitle", appTitle)
    def getAppVersionCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("appVersionCode", appVersionCode)
    def getAttributes: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getClientSdkVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientSdkVersion", clientSdkVersion)
    def getEventType: ZIO[Any, Nothing, __string] = ZIO.succeed(eventType)
    def getMetrics: ZIO[Any, AwsError, Map[__string, __double]] =
      AwsError.unwrapOptionField("metrics", metrics)
    def getSdkName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sdkName", sdkName)
    def getSession
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Session.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
    def getTimestamp: ZIO[Any, Nothing, __string] = ZIO.succeed(timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Event
  ) extends zio.aws.pinpoint.model.Event.ReadOnly {
    override val appPackageName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appPackageName())
      .map(value => value: __string)
    override val appTitle: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appTitle())
      .map(value => value: __string)
    override val appVersionCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.appVersionCode())
      .map(value => value: __string)
    override val attributes: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val clientSdkVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSdkVersion())
      .map(value => value: __string)
    override val eventType: __string = impl.eventType(): __string
    override val metrics: Optional[Map[__string, __double]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __double)
            })
            .toMap
        )
    override val sdkName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.sdkName())
      .map(value => value: __string)
    override val session: Optional[zio.aws.pinpoint.model.Session.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.session())
        .map(value => zio.aws.pinpoint.model.Session.wrap(value))
    override val timestamp: __string = impl.timestamp(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Event
  ): zio.aws.pinpoint.model.Event.ReadOnly = new Wrapper(impl)
}
